// ContentsEsc_c.cpp : CContentsEsc_c Class source code
//

#include "stdafx.h"
#include "defsfile.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

IMPLEMENT_SERIAL(CContentsEsc_c, CObject, 1)



// Serialize draw data
void CContentsEsc_c::Serialize(CArchive& ar)
{
    CObject::Serialize(ar);

    if (ar.IsStoring ())
        ar.Write(&m_Data,sizeof(m_Data)) ;
    else
        ar.Read(&m_Data,sizeof(m_Data)) ;
}

// Draw to Window
void CContentsEsc_c::Draw(CDC* pDC)
{
	CGpWinPen Pen( m_Data.cDisplayColor,0) ;
	CGpWinBrush Brush( m_Data.cTile) ;

	CPen* pOldPen         = pDC->SelectObject((CPen* )&Pen);
	int OldBkMode         = pDC->SetBkMode( OPAQUE );
	COLORREF OldBkColor   = pDC->SetBkColor(GpToWinColor(m_Data.cBackColor));
	CBrush* pOldBrush     = pDC->SelectObject((CBrush* )&Brush);
	COLORREF OldTextColor = pDC->SetTextColor(GpToWinColor(m_Data.cDisplayColor));

	int x1,y1,x2,y2 ;
	x1 = m_Data.iX1 - m_Data.iRadius ; y1 = m_Data.iY1 - m_Data.iRadius ;
	x2 = m_Data.iX1 + m_Data.iRadius ; y2 = m_Data.iY1 + m_Data.iRadius ;
	pDC->Ellipse(x1,y1,x2,y2);

	pDC->SetBkMode(OldBkMode );
	pDC->SetBkColor( OldBkColor );
	pDC->SelectObject(pOldPen);
	pDC->SelectObject(pOldBrush);
	pDC->SetTextColor(OldTextColor);
}

// Transmit the data to GP
int CContentsEsc_c::Transition( CMemSock* pCMemSock)
{
	return( pCMemSock->MtoMESC_c(m_Data.cDisplayColor,m_Data.cBackColor,m_Data.cTile,m_Data.iX1,m_Data.iY1,m_Data.iRadius)) ;
}
